function [R,T]=factRT(obj)
% FactRT retourne les facteurs de rflexion et de transmission
%   en courant de probabilit d'un objet physique interagissant avec une
%   marche d'nergie potentielle.
%   [R,T]=FactRT(obj)
%       >> obj  = objet informatique marche;
%       << R    = facteur de rflexion en courant de probabilit;
%       << T    = facteur de transmission en courant de probabilit.
%
%   Olivier Pujol : septembre 2013
%
%% Vrifications

if (isa(obj,'marche')==0),error('Mauvais type d''objet !');end
if (obj.ke==0),error('Cas singulier k=0 !');end

%% Matrice de rflexion-rfraction de la marche

mat=matrix(obj);
%
%% Calcul de s facteurs R et T

if (isreal(obj.ks)==1)
    T=1/(abs(mat(2,2)))^2;
    R=(abs(-mat(2,1)/mat(2,2)))^2;
end
%
if (isreal(obj.ks)==0)
     T=0;
     R=1;
end
%
return;